# 🛠️ Server Configuration Guide

## 📁 **MetaChain Integration Setup**

### **Current Structure:**
```
core.galliumhash.com/          ← Bitcoin Hub (existing)
core.galliumhash.com/metachain ← Multi-Chain Hub (new)
```

### **Required Server Configuration:**

#### **Option 1: Folder-Based (Recommended)**
- Upload entire `/metachain/` folder to your server
- Access via: `yourdomain.com/metachain/`
- No server config changes needed

#### **Option 2: Subdomain Setup (Alternative)**
- Create: `metachain.galliumhash.com`
- Point to the same server directory
- Better SEO and branding

#### **Option 3: Virtual Host (Advanced)**
- Configure Apache/Nginx for subdirectory
- Maintains existing URLs while adding new functionality

### **Database Setup Required:**
```sql
-- Create new database for MetaChain
CREATE DATABASE nvdaxcom_galliumhash_metachain;

-- Copy schema from existing metabuilder database
-- Update connection strings in backend files
```

### **Testing Steps:**
1. ✅ Upload `/metachain/` folder to server
2. ✅ Create new metachain database
3. ✅ Test: `yourdomain.com/metachain/`
4. ✅ Verify chain selection interface loads
5. 🔄 Start Ethereum hub development

### **Navigation Integration:**
```html
<!-- Add to main Bitcoin dashboard -->
<a href="/metachain/" class="chain-nav">🌌 Multi-Chain Intelligence</a>

<!-- Add to MetaChain landing -->
<a href="../" class="chain-nav">← Back to Bitcoin Hub</a>
```

**RESULT**: Unified Meta Ecosystem with clean URL separation!